/*
 * GameFrame.java
 *
 * Created on Jun 18, 2012, 9:09:19 PM
 */
package net.drthum.games.simon.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import net.drthum.games.simon.engine.Engine;

/**
 *
 * @author DrThum <thum@drthum.net>
 */
public class GameFrame extends javax.swing.JFrame {
    private Action[] updateFlash;
    private Timer[] flashTimers;
    private Engine game;

    /** Creates new form GameFrame */
    public GameFrame() {
        updateFlash = new Action[4];
        flashTimers = new Timer[4];
        
        for (int i = 0; i < 4; i++) {
            final int index = i;
            updateFlash[i] = new AbstractAction() {
                @Override
                public void actionPerformed(ActionEvent ae) {
                    deactivate(index);
                }
            };

            flashTimers[i] = new Timer(250, updateFlash[i]);
            flashTimers[i].setRepeats(false);
        }
        
        game = new Engine();
        for (int i = 0; i < 10; i++) {
            game.genStep();
        }
        
        initComponents();
        pack();
    }
    
    public void activate(int index) {
        switch (index) {
            case 0: // Top left
                lTopLeft.setBackground(Color.GREEN);
                break;
            case 1: // Top right
                lTopRight.setBackground(Color.RED);
                break;
            case 2: // Bottom left
                lBottomLeft.setBackground(Color.BLUE);
                break;
            case 3: // Bottom right
                lBottomRight.setBackground(Color.YELLOW);
                break;
        }
    }
    
    public void deactivate(int index) {
        switch (index) {
            case 0: // Top left
                lTopLeft.setBackground(new Color(0, 102, 0));
                break;
            case 1: // Top right
                lTopRight.setBackground(new Color(153, 0, 0));
                break;
            case 2: // Bottom left
                lBottomLeft.setBackground(new Color(0, 0, 102));
                break;
            case 3: // Bottom right
                lBottomRight.setBackground(new Color(213, 213, 10));
                break;
        }
    }
    
    public void flash(int index) {        
        activate(index);
        flashTimers[index].restart();
    }
    
    private void showSequence() {
        List<Integer> sequence = game.getCurrentSequence();
        Iterator<Integer> it = sequence.iterator();
        Integer curr;
        
        while (it.hasNext()) {
            curr = it.next();
            flash(curr);
            try {
                Thread.sleep(300);
            } catch (InterruptedException ex) {
                continue;
            }
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lTopLeft = new javax.swing.JLabel();
        lTopRight = new javax.swing.JLabel();
        lBottomLeft = new javax.swing.JLabel();
        lBottomRight = new javax.swing.JLabel();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        miNewGame = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        miQuit = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Simon's Game");
        getContentPane().setLayout(new java.awt.GridLayout(2, 2, 10, 10));

        lTopLeft.setBackground(new java.awt.Color(0, 102, 0));
        lTopLeft.setName("lTopLeft"); // NOI18N
        lTopLeft.setOpaque(true);
        lTopLeft.setPreferredSize(new java.awt.Dimension(100, 100));
        lTopLeft.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lTopLeftMouseClicked(evt);
            }
        });
        getContentPane().add(lTopLeft);

        lTopRight.setBackground(new java.awt.Color(153, 0, 0));
        lTopRight.setName("lTopRight"); // NOI18N
        lTopRight.setOpaque(true);
        lTopRight.setPreferredSize(new java.awt.Dimension(100, 100));
        lTopRight.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lTopRightMouseClicked(evt);
            }
        });
        getContentPane().add(lTopRight);

        lBottomLeft.setBackground(new java.awt.Color(0, 0, 102));
        lBottomLeft.setName("lBottomLeft"); // NOI18N
        lBottomLeft.setOpaque(true);
        lBottomLeft.setPreferredSize(new java.awt.Dimension(100, 100));
        lBottomLeft.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lBottomLeftMouseClicked(evt);
            }
        });
        getContentPane().add(lBottomLeft);

        lBottomRight.setBackground(new java.awt.Color(213, 213, 10));
        lBottomRight.setName("lBottomRight"); // NOI18N
        lBottomRight.setOpaque(true);
        lBottomRight.setPreferredSize(new java.awt.Dimension(100, 100));
        lBottomRight.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lBottomRightMouseClicked(evt);
            }
        });
        getContentPane().add(lBottomRight);

        jMenuBar1.setName("jMenuBar1"); // NOI18N

        jMenu1.setText("File");
        jMenu1.setName("jMenu1"); // NOI18N

        miNewGame.setText("New game");
        miNewGame.setName("miNewGame"); // NOI18N
        miNewGame.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miNewGameActionPerformed(evt);
            }
        });
        jMenu1.add(miNewGame);

        jSeparator1.setName("jSeparator1"); // NOI18N
        jMenu1.add(jSeparator1);

        miQuit.setText("Quit");
        miQuit.setName("miQuit"); // NOI18N
        miQuit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miQuitActionPerformed(evt);
            }
        });
        jMenu1.add(miQuit);

        jMenuBar1.add(jMenu1);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void lTopLeftMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lTopLeftMouseClicked
    flash(0);
}//GEN-LAST:event_lTopLeftMouseClicked

private void lTopRightMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lTopRightMouseClicked
    flash(1);
}//GEN-LAST:event_lTopRightMouseClicked

private void lBottomLeftMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lBottomLeftMouseClicked
    flash(2);
}//GEN-LAST:event_lBottomLeftMouseClicked

private void lBottomRightMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lBottomRightMouseClicked
    flash(3);
}//GEN-LAST:event_lBottomRightMouseClicked

private void miQuitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miQuitActionPerformed
    System.exit(0);
}//GEN-LAST:event_miQuitActionPerformed

private void miNewGameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miNewGameActionPerformed
    // TODO add your handling code here:
}//GEN-LAST:event_miNewGameActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JLabel lBottomLeft;
    private javax.swing.JLabel lBottomRight;
    private javax.swing.JLabel lTopLeft;
    private javax.swing.JLabel lTopRight;
    private javax.swing.JMenuItem miNewGame;
    private javax.swing.JMenuItem miQuit;
    // End of variables declaration//GEN-END:variables
}
