/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SAIGenFrame
extends JFrame
implements ActionListener,
ChangeListener,
MouseListener {
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newScriptItem;
    private JMenuItem saveScriptItem;
    private JMenuItem loadScriptItem;
    private JMenuItem quitItem;
    private Box entryBox;
    private Box evtIdBox;
    private JTabbedPane tabs;
    private final JFileChooser fc = new JFileChooser();
    private ArrayList<SAIGenEventData> events = new ArrayList();
    private JButton saveEventBtn;
    private JButton addEventBtn;
    private JButton removeEventBtn;
    private SpinnerNumberModel model;
    private JSpinner spinner;
    private int maxEvtId = 0;
    private JPanel statusBar;
    private JLabel statusText;
    private final int TYPE_EVENT = 0;
    private final int TYPE_ACTION = 1;
    private final int TYPE_TARGET = 2;
    private JLabel entryLabel;
    private JTextField entryField;
    private JLabel evtIdLabel;
    private JTextField evtIdField;
    private JLabel linkL;
    private JTextField linkTF;
    private JLabel typeL;
    private JComboBox typeCB;
    private JLabel chanceL;
    private JTextField chanceTF;
    private JLabel flagsL;
    private JTextField flagsTF;
    private JLabel ep1L;
    private JTextField ep1TF;
    private JLabel ep2L;
    private JTextField ep2TF;
    private JLabel ep3L;
    private JTextField ep3TF;
    private JLabel ep4L;
    private JTextField ep4TF;
    private JLabel commentL;
    private JTextField commentTF;
    private JLabel atypeL;
    private JComboBox atypeCB;
    private JLabel ap1L;
    private JTextField ap1TF;
    private JLabel ap2L;
    private JTextField ap2TF;
    private JLabel ap3L;
    private JTextField ap3TF;
    private JLabel ap4L;
    private JTextField ap4TF;
    private JLabel ap5L;
    private JTextField ap5TF;
    private JLabel ap6L;
    private JTextField ap6TF;
    private JLabel ttypeL;
    private JComboBox ttypeCB;
    private JLabel tp1L;
    private JTextField tp1TF;
    private JLabel tp2L;
    private JTextField tp2TF;
    private JLabel tp3L;
    private JTextField tp3TF;
    private JLabel pxL;
    private JTextField pxTF;
    private JLabel pyL;
    private JTextField pyTF;
    private JLabel pzL;
    private JTextField pzTF;
    private JLabel oriL;
    private JTextField oriTF;
    private String[] eventTypes = new String[]{"Timer en combat", "Timer hors combat", "Vie (%)", "Mana (%)", "Aggro", "Cible tu\u00e9e", "Mort", "Evasion (fin de combat)", "Touch\u00e9 par sort", "Cible \u00e0 distance", "Champ de vision (hors combat)", "Respawn", "Vie de la cible (%)", "Cible lance sort", "Cible amie - Vie (absolue)", "Cible amie control\u00e9e", "Cible amie - Buff absent", "Unit\u00e9 invoqu\u00e9e", "Mana de la cible (%)", "Qu\u00eate accept\u00e9e par le joueur", "Qu\u00eate r\u00e9compens\u00e9e pour le joueur", "Retour au spawn", "R\u00e9ception d'emote", "A un buff", "Cible buff\u00e9e", "Reset", "Champ de vision (en combat)", "Non utilis\u00e9", "Non utilis\u00e9", "Charm\u00e9", "Cible charm\u00e9e", "Sort touche cible", "D\u00e9gats re\u00e7us", "D\u00e9gats inflig\u00e9s", "Information d\u00e9placements", "Unit\u00e9 invoqu\u00e9e (despawn)", "Cadavre despawn", "Initialisation AI", "Donn\u00e9es de script (r\u00e9ception)", "Chemin (d\u00e9part)", "Chemin (Point de passage)", "Transport (ajout joueur)", "Transport (ajout cr\u00e9ature)", "Transport (retrait joueur)", "Transport (d\u00e9placements)", "Instance (entr\u00e9e joueur)", "AreaTrigger", "Non utilis\u00e9", "Non utilis\u00e9", "Non utilis\u00e9", "Non utilis\u00e9", "Non utilis\u00e9", "Timer texte \u00e9coul\u00e9", "Heal re\u00e7u", "Invoqu\u00e9 par autre unit\u00e9", "Chemin (pause)", "Chemin (reprise)", "Chemin (arr\u00eat forc\u00e9)", "Chemin (termin\u00e9)", "Event sous timer pr\u00eat", "Timer (en et hors combat)", "Event li\u00e9", "Menu d'options (s\u00e9lection)", "Event sous timer (cr\u00e9ation)", "Menu d'options (affichage)", "Quest follow (fin)", "Cible tu\u00e9e par ma\u00eetre", "Effet dummy"};
    private String[] actionTypes = new String[]{"Aucune", "Dire texte", "Changer de faction", "Morph", "Jouer son", "Jouer emote", "Faire \u00e9chouer la qu\u00eate", "Ajouter qu\u00eate au joueur", "Changer type de r\u00e9action", "Activer GameObject", "Jouer emote (al\u00e9atoire)", "Lancer sort", "Invoquer unit\u00e9", "Modifier menace individuelle (%)", "Modifier menace tous (%)", "Qu\u00eate (exploration)", "Qu\u00eate (cast creature or go)", "Emote (\u00e9tat)", "Unit Flag (set)", "Unit Flag (remove)", "Auto attack", "Autoriser mouvement en combat", "Event (passer en phase)", "Event (incr\u00e9menter phase)", "Evasion", "Fuite", "GroupEventHappens", "Qu\u00eate (casted creature or go)", "Retirer buff", "Suivre", "Event (phase al\u00e9atoire)", "Event (intervalle phase al\u00e9atoire)", "Reset GameObject", "Qu\u00eate (monstre tu\u00e9)", "Instance (set data)", "Instance (set data64)", "Changer de template", "Suicide", "Mettre zone en combat", "Appeler \u00e0 l'aide", "Changer arme", "Despawn forc\u00e9 (timer)", "Non utilis\u00e9", "Monture", "Non utilis\u00e9", "Donn\u00e9es de script (envoi)", "Avancer", "Changer de visibilit\u00e9", "Rendre actif", "Commencer l'attaque", "Invoquer GameObject", "Tuer cible", "Chemin (chargement)", "Chemin (d\u00e9part)", "Chemin (pause)", "Chemin (arr\u00eat forc\u00e9)", "Add Item", "Retrait Item", "Non utilis\u00e9", "Marcher/Courir", "Voler", "Nager", "T\u00e9l\u00e9portation", "Stocker variable", "Stocker liste de cibles", "Chemin (reprise)", "Changer l'orientation", "Event sous timer (cr\u00e9ation)", "Lancer cin\u00e9matique", "D\u00e9placement vers position", "Respawn Cible", "Equiper stuff", "Menu d'options (fermer)", "Event sous timer (d\u00e9clenchement)", "Event sous timer (suppression)", "Ajouter buff", "Non utilis\u00e9", "Script (reset)", "Non utilis\u00e9", "Lancer une liste d'event (sous timer)", "NPC Flag (set)", "NPC Flag (add)", "NPC Flag (remove)", "Suivre ma\u00eetre", "Stop combat", "Non utilis\u00e9", "Non utilis\u00e9", "Non utilis\u00e9", "Mouvement al\u00e9atoire"};
    private String[] targetTypes = new String[]{"Aucune", "Soi-m\u00eame", "Cible actuelle", "Liste d'aggro (2e)", "Liste d'aggro (dernier)", "Liste d'aggro (al\u00e9atoire)", "Liste d'aggro (al\u00e9atoire sauf premier)", "Unit\u00e9 \u00e0 l'origine de l'event", "Position", "Cible \u00e0 distance (intervalle)", "Par GUID", "Cible \u00e0 distance (rayon)", "Liste de cibles stock\u00e9es", "GameObject \u00e0 distance (intervalle)", "GameObject par GUID", "GameObject \u00e0 distance (rayon)", "Groupe de l'unit\u00e9 \u00e0 l'origine de l'event", "Joueurs \u00e0 distance (intervalle)", "Joueurs \u00e0 distance (rayon)", "Creature la plus proche", "GameObject le plus proche", "Joueur le plus proche"};
    private String[] eventParam1Labels = new String[]{"Timer initial (min)", "Timer initial (min)", "Vie min (%)", "Mana min (%)", null, "Cooldown (min)", null, null, "ID du sort", "Distance (min)", "1 = Amical, 0 = Hostile", "Type", "Vie min (%)", "R\u00e9p\u00e9tition (min)", "D\u00e9ficit en vie (absolue)", "Rayon", "ID du spell", "ID de la cr\u00e9ature", "Mana min (%)", "ID de la qu\u00eate (0 = toutes)", "ID de la qu\u00eate (0 = toutes)", null, "ID de l'emote", "ID du spell", "ID du spell", null, "1 = Amical, 0 = Hostile", "Cooldown (min)", null, null, null, "ID du spell", "D\u00e9g\u00e2ts (min)", "D\u00e9g\u00e2ts (min)", "Type de mouvement", "ID de la cr\u00e9ature", null, null, "ID du type de donn\u00e9es", "ID du point de passage (0 = tous)", "ID du point de passage (0 = tous)", null, "ID de la cr\u00e9ature (0 = tous)", null, "ID du point de passage", "Faction (0 = toutes)", "ID de l'areatrigger (0 = tous)", null, null, null, null, null, "ID du groupe de textes (0 = tous)", "Heal (min)", null, "ID du point de passage (0 = tous)", "ID du point de passage (0 = tous)", "ID du point de passage (0 = tous)", "ID du point de passage (0 = tous)", "ID de l'event", "Timer initial (min)", null, "Sender", null, null, null, "ID de la cr\u00e9ature tu\u00e9e", "ID du sort"};
    private String[] eventParam2Labels = new String[]{"Timer initial (max)", "Timer initial (max)", "Vie max (%)", "Mana max (%)", null, "Cooldown (max)", null, null, "Ecole du sort", "Distance (max)", "Port\u00e9e (max)", "ID de la map", "Vie max (%)", "R\u00e9p\u00e9tition (max)", "Rayon", "R\u00e9p\u00e9tition (min)", "Rayon", "Cooldown (min)", "Mana max (%)", null, null, null, "Cooldown (min)", "Nombre de stacks", "Nombre de stacks", null, "Port\u00e9e (max)", "Cooldown (max)", "Cooldown (max)", null, null, "Ecole du sort", "D\u00e9g\u00e2ts (max)", "D\u00e9g\u00e2ts (max)", "ID du point de passage", "Cooldown (min)", null, null, "Valeur", "ID du chemin (0 = tous)", "ID du chemin (0 = tous)", null, null, null, null, "Cooldown (min)", null, null, null, null, null, null, null, "Heal (max)", null, "ID du chemin (0 = tous)", "ID du chemin (0 = tous)", "ID du chemin (0 = tous)", "ID du chemin (0 = tous)", null, "Timer initial (max)", null, "Action", null, null, null, null, "Index de l'effet"};
    private String[] eventParam3Labels = new String[]{"R\u00e9p\u00e9tition (min)", "R\u00e9p\u00e9tition (min)", "R\u00e9p\u00e9tition (min)", "R\u00e9p\u00e9tition (min)", null, "1 = Seulement joueur", null, null, "Cooldown (min)", "R\u00e9p\u00e9tition (min)", "Cooldown (min)", "ID de la zone", "R\u00e9p\u00e9tition (min)", null, "R\u00e9p\u00e9tition (min)", "R\u00e9p\u00e9tition (max)", "R\u00e9p\u00e9tition (min)", "Cooldown (max)", "R\u00e9p\u00e9tition (min)", null, null, null, "Cooldown (max)", "R\u00e9p\u00e9tition (min)", "R\u00e9p\u00e9tition (min)", null, "Cooldown (min)", null, null, null, null, "Cooldown (min)", "Cooldown (min)", "Cooldown (min)", null, "Cooldown (max)", null, null, "Cooldown (max)", null, null, null, null, null, null, "Cooldown (max)", null, null, null, null, null, null, null, "Cooldown (min)", null, null, null, null, null, null, "R\u00e9p\u00e9tition (min)", null, null, null, null, null, null, null};
    private String[] eventParam4Labels = new String[]{"R\u00e9p\u00e9tition (max)", "R\u00e9p\u00e9tition (max)", "R\u00e9p\u00e9tition (max)", "R\u00e9p\u00e9tition (max)", null, "Si pas joueur seulement, ID de la cr\u00e9ature", null, null, "Cooldown (max)", "R\u00e9p\u00e9tition (max)", "Cooldown (max)", null, "R\u00e9p\u00e9tition (max)", null, "R\u00e9p\u00e9tition (max)", null, "R\u00e9p\u00e9tition (max)", null, "R\u00e9p\u00e9tition (max)", null, null, null, null, "R\u00e9p\u00e9tition (max)", "R\u00e9p\u00e9tition (max)", null, "Cooldown (max)", null, null, null, null, "Cooldown (max)", "Cooldown (max)", "Cooldown (max)", null, null, null, null, "Cooldown (max)", null, null, null, null, null, null, null, null, null, null, null, null, null, null, "Cooldown (max)", null, null, null, null, null, null, "R\u00e9p\u00e9tition (max)", null, null, null, null, null, null, null};
    private String[] actionParam1Labels = new String[]{null, "ID du groupe de texte", "ID de la faction (0 = faction d'origine)", "ID du template", "ID du son", "ID de l'emote", "ID de la qu\u00eate", "ID de la qu\u00eate", "R\u00e9action", "GUID du GameObject", "ID de l'emote1", "ID du sort", "ID de la cr\u00e9ature", "Menace (%)", "Menace (%)", "ID de la qu\u00eate", "ID de la qu\u00eate", "ID de l'emote", "Flags", "Flags", "0 = Sur place, 1 = Mouvement", "Phase", "Valeur", null, null, "ID de la qu\u00eate", "ID de la cr\u00e9ature", "ID du sort", "Distance", "ID Phase 1", "Phase (min)", "GUID du GameObject", "ID de la cr\u00e9ature", "Type de donn\u00e9es", "Type de donn\u00e9es", "ID du template", null, null, "Rayon", "0 = rien, 1 = m\u00eal\u00e9e, 2 = \u00e0 distance", "Timer", "Vie (Positif = %, N\u00e9gatif = absolu)", "ID du template de la monture (0 = dismount)", "Mask", "Type de donn\u00e9es", "Distance", "0 = invisible, 1 = visible", null, "GUID de la cible (?)", "ID du GameObject", "GUID de la cible (?)", "ID du chemin", "0 = marcher, 1 = courir", "Timer", "Timer de despawn", "ID de l'item", "ID de l'item", "ID du template d'IA", "0 = marcher, 1 = courir", "0 = marcher, 1 = voler", "0 = marcher, 1 = nager", "ID de la map", "ID de la variable stock\u00e9e", "ID de la variable stock\u00e9e", null, "GUID de la cible (?)", "ID de l'event", "ID de la cin\u00e9matique", null, "GUID de la cible (?)", "Entr\u00e9e slot 1", null, "ID de l'event", "ID de l'event", "ID du sort", "GUID de la cible (?)", null, null, "ID de la liste", "Flags", "Flags", "Flags", null, null, null, null, null, "Distance (max)"};
    private String[] actionParam2Labels = new String[]{null, null, null, "ID du mod\u00e8le (si pas de param\u00e8tre 1)", null, null, null, null, null, null, "ID de l'emote 2", "1 = triggered, 2 = force cast", "Type d'invocation", null, null, null, "ID du sort", null, null, null, null, null, null, null, null, null, "ID du sort", null, "Angle", "ID de phase 2", "Phase (max)", null, null, "Donn\u00e9es", null, "Faction", null, null, null, null, null, null, "ID du mod\u00e8le (si pas de param\u00e8tre 1) ou 0 pour dismount", null, "Donn\u00e9es", null, null, null, null, "Timer de despawn (ms)", null, null, "ID du chemin", null, "ID de la qu\u00eate (facultatif)", "Nombre d'items", "Nombre d'items", null, null, null, null, null, "Valeur \u00e0 stocker", null, null, null, "Timer initial (min)", null, null, null, "Entr\u00e9e slot 2", null, null, null, null, null, null, null, "0 = continuer apr\u00e8s le combat, 1 = stop", null, null, null, null, null, null, null, null, null};
    private String[] actionParam3Labels = new String[]{null, null, null, null, null, null, null, null, null, null, "ID de l'emote 3", null, "Dur\u00e9e (ms)", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "ID de la cr\u00e9ature de fin", "ID de phase 3", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "1 = chemin r\u00e9p\u00e9t\u00e9", null, "1 = faire \u00e9chouer la qu\u00eate", null, null, null, null, null, null, null, null, null, null, null, "Timer initial (max)", null, null, null, "Entr\u00e9e slot 3", null, null, null, null, null, null, null, "0 = timer hors combat, 1 = en combat, 2 = tout le temps", null, null, null, null, null, null, null, null, null};
    private String[] actionParam4Labels = new String[]{null, null, null, null, null, null, null, null, null, null, "ID de l'emote 4", null, "Toujours 0", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "Cr\u00e9dit de la qu\u00eate", "ID de phase 4", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "R\u00e9p\u00e9tition (min)", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] actionParam5Labels = new String[]{null, null, null, null, null, null, null, null, null, null, null, "AttackInvoker", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "0 = kill de monstre, 1 = event", "ID de phase 4", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "R\u00e9p\u00e9tition (max)", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] actionParam6Labels = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "R\u00e9action", null, null, null, null, null, null, null, null, null, null, null, null, null, "Chance", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] targetParam1Labels = new String[]{null, null, null, null, null, null, null, null, null, "ID de la cr\u00e9ature (0 = tous)", "GUID de la cible", "ID de la cr\u00e9ature (0 = tous)", "ID", "ID du GameObject", "GUID du GameObject", "ID du GameObject", null, "Distance (min)", "Distance (max)", "ID de la cr\u00e9ature (0 = tous)", "ID du GameObject (0 = tous)", null, null, null, null};
    private String[] targetParam2Labels = new String[]{null, null, null, null, null, null, null, null, null, "Distance (min)", "ID de la cr\u00e9ature (0 = tous)", "Distance (max)", null, "Distance (min)", "ID du GameObject", "Distance (max)", null, "Distance (max)", null, null, null, null, null, null, null};
    private String[] targetParam3Labels = new String[]{null, null, null, null, null, null, null, null, null, "Distance (max)", null, null, null, "Distance (max)", null, null, null, null, null, null, null, null, null, null, null};
    private String[] targetXLabels = new String[]{null, null, null, null, null, null, null, null, "X", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] targetYLabels = new String[]{null, null, null, null, null, null, null, null, "Y", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] targetZLabels = new String[]{null, null, null, null, null, null, null, null, "Z", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] targetOLabels = new String[]{null, null, null, null, null, null, null, null, "Orientation", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};

    public SAIGenFrame() {
        super("G\u00e9n\u00e9rateur de scripts SmartAI");
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(800, 400));
        this.setResizable(false);
        this.setupFileChooser();
        this.setupMenu();
        this.setupFrame();
        this.initFields(null, false);
        this.updateLabels(0, this.typeCB.getSelectedIndex());
        this.updateLabels(1, this.atypeCB.getSelectedIndex());
        this.updateLabels(2, this.ttypeCB.getSelectedIndex());
        this.pack();
        this.setVisible(true);
    }

    private void setupFileChooser() {
        this.fc.setFileFilter(new SAIGenFileChooserFilter());
    }

    private void setupMenu() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("Fichier");
        this.menuBar.add(this.fileMenu);
        this.newScriptItem = new JMenuItem("Nouveau script");
        this.saveScriptItem = new JMenuItem("Sauver script");
        this.loadScriptItem = new JMenuItem("Ouvrir script");
        this.quitItem = new JMenuItem("Quitter");
        this.fileMenu.add(this.newScriptItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.loadScriptItem);
        this.loadScriptItem.addActionListener(this);
        this.fileMenu.add(this.saveScriptItem);
        this.saveScriptItem.addActionListener(this);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.quitItem);
        this.quitItem.addActionListener(this);
        this.setJMenuBar(this.menuBar);
        this.menuBar.addMouseListener(this);
    }

    private void setupFrame() {
        Container container = this.getContentPane();
        this.entryBox = Box.createHorizontalBox();
        this.evtIdBox = Box.createHorizontalBox();
        container.setLayout(new BoxLayout(container, 1));
        this.entryBox.add(Box.createHorizontalStrut(342));
        this.entryLabel = new JLabel("ID monstre : ");
        this.entryBox.add(this.entryLabel);
        this.entryBox.add(Box.createHorizontalStrut(8));
        this.entryField = new JTextField();
        this.entryBox.add(this.entryField);
        this.entryBox.add(Box.createHorizontalStrut(250));
        this.evtIdBox.add(Box.createHorizontalStrut(250));
        this.evtIdLabel = new JLabel("Num event :  ");
        this.evtIdBox.add(Box.createHorizontalStrut(100));
        this.model = new SpinnerNumberModel(0, 0, 99, 1);
        this.spinner = new JSpinner(this.model);
        this.spinner.addChangeListener(this);
        this.evtIdLabel.setLabelFor(this.spinner);
        this.evtIdBox.add(this.evtIdLabel);
        this.evtIdBox.add(this.spinner);
        this.evtIdBox.add(Box.createHorizontalStrut(60));
        this.addEventBtn = new JButton("+");
        this.addEventBtn.addActionListener(this);
        this.evtIdBox.add(this.addEventBtn);
        this.evtIdBox.add(Box.createHorizontalStrut(10));
        this.removeEventBtn = new JButton("-");
        this.removeEventBtn.addActionListener(this);
        this.evtIdBox.add(this.removeEventBtn);
        this.evtIdBox.add(Box.createHorizontalStrut(100));
        container.add(this.entryBox);
        container.add(Box.createVerticalStrut(5));
        container.add(this.evtIdBox);
        container.add(Box.createVerticalStrut(10));
        this.tabs = new JTabbedPane();
        JComponent jComponent = this.makeEventPanel();
        this.tabs.addTab("Event", null, jComponent, "Event");
        JComponent jComponent2 = this.makeActionPanel();
        this.tabs.addTab("Action", null, jComponent2, "Action");
        JComponent jComponent3 = this.makeTargetPanel();
        this.tabs.addTab("Cible", null, jComponent3, "Cible");
        container.add(this.tabs);
        container.add(Box.createVerticalStrut(10));
        this.saveEventBtn = new JButton("Enregistrer event");
        this.saveEventBtn.addActionListener(this);
        container.add(this.saveEventBtn);
        container.add(Box.createVerticalStrut(23));
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new FlowLayout(0));
        this.statusText = new JLabel("Pr\u00eat.");
        this.statusBar.add(this.statusText);
        container.add(this.statusBar);
        container.add(Box.createVerticalStrut(2));
        this.addMouseListener(this);
        this.tabs.addMouseListener(this);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width / 2 - 400;
        int n2 = dimension.height / 2 - 200;
        this.setBounds(n, n2, 800, 400);
    }

    private JComponent makeTextPanel(String string) {
        JPanel jPanel = new JPanel(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        return jPanel;
    }

    private JComponent makeEventPanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridLayout(9, 2));
        this.linkL = new JLabel("ID event li\u00e9 : ");
        this.linkTF = new JTextField();
        jPanel.add(this.linkL);
        jPanel.add(this.linkTF);
        this.typeL = new JLabel("Type : ");
        this.typeCB = new JComboBox<String>(this.eventTypes);
        this.typeCB.addActionListener(this);
        jPanel.add(this.typeL);
        jPanel.add(this.typeCB);
        this.chanceL = new JLabel("Chances de se produire (%) : ");
        this.chanceTF = new JTextField();
        jPanel.add(this.chanceL);
        jPanel.add(this.chanceTF);
        this.flagsL = new JLabel("Flags : ");
        this.flagsTF = new JTextField();
        jPanel.add(this.flagsL);
        jPanel.add(this.flagsTF);
        this.ep1L = new JLabel("Param\u00e8tre 1 : ");
        this.ep1TF = new JTextField();
        jPanel.add(this.ep1L);
        jPanel.add(this.ep1TF);
        this.ep2L = new JLabel("Param\u00e8tre 2 : ");
        this.ep2TF = new JTextField();
        jPanel.add(this.ep2L);
        jPanel.add(this.ep2TF);
        this.ep3L = new JLabel("Param\u00e8tre 3 : ");
        this.ep3TF = new JTextField();
        jPanel.add(this.ep3L);
        jPanel.add(this.ep3TF);
        this.ep4L = new JLabel("Param\u00e8tre 4 : ");
        this.ep4TF = new JTextField();
        jPanel.add(this.ep4L);
        jPanel.add(this.ep4TF);
        this.commentL = new JLabel("Commentaire : ");
        this.commentTF = new JTextField();
        jPanel.add(this.commentL);
        jPanel.add(this.commentTF);
        return jPanel;
    }

    private JComponent makeActionPanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridLayout(8, 2));
        this.atypeL = new JLabel("Type : ");
        this.atypeCB = new JComboBox<String>(this.actionTypes);
        this.atypeCB.addActionListener(this);
        jPanel.add(this.atypeL);
        jPanel.add(this.atypeCB);
        this.ap1L = new JLabel("Param\u00e8tre 1 : ");
        this.ap1TF = new JTextField();
        jPanel.add(this.ap1L);
        jPanel.add(this.ap1TF);
        this.ap2L = new JLabel("Param\u00e8tre 2 : ");
        this.ap2TF = new JTextField();
        jPanel.add(this.ap2L);
        jPanel.add(this.ap2TF);
        this.ap3L = new JLabel("Param\u00e8tre 3 : ");
        this.ap3TF = new JTextField();
        jPanel.add(this.ap3L);
        jPanel.add(this.ap3TF);
        this.ap4L = new JLabel("Param\u00e8tre 4 : ");
        this.ap4TF = new JTextField();
        jPanel.add(this.ap4L);
        jPanel.add(this.ap4TF);
        this.ap5L = new JLabel("Param\u00e8tre 5 : ");
        this.ap5TF = new JTextField();
        jPanel.add(this.ap5L);
        jPanel.add(this.ap5TF);
        this.ap6L = new JLabel("Param\u00e8tre 6 : ");
        this.ap6TF = new JTextField();
        jPanel.add(this.ap6L);
        jPanel.add(this.ap6TF);
        return jPanel;
    }

    private JComponent makeTargetPanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridLayout(9, 2));
        this.ttypeL = new JLabel("Type : ");
        this.ttypeCB = new JComboBox<String>(this.targetTypes);
        this.ttypeCB.addActionListener(this);
        jPanel.add(this.ttypeL);
        jPanel.add(this.ttypeCB);
        this.tp1L = new JLabel("Param\u00e8tre 1 : ");
        this.tp1TF = new JTextField();
        jPanel.add(this.tp1L);
        this.tp1TF.addActionListener(this);
        jPanel.add(this.tp1TF);
        this.tp2L = new JLabel("Param\u00e8tre 2 : ");
        this.tp2TF = new JTextField();
        this.tp2TF.addActionListener(this);
        jPanel.add(this.tp2L);
        jPanel.add(this.tp2TF);
        this.tp3L = new JLabel("Param\u00e8tre 3 : ");
        this.tp3TF = new JTextField();
        this.tp3TF.addActionListener(this);
        jPanel.add(this.tp3L);
        jPanel.add(this.tp3TF);
        this.pxL = new JLabel("Position X : ");
        this.pxTF = new JTextField();
        this.pxTF.addActionListener(this);
        jPanel.add(this.pxL);
        jPanel.add(this.pxTF);
        this.pyL = new JLabel("Position Y : ");
        this.pyTF = new JTextField();
        this.pyTF.addActionListener(this);
        jPanel.add(this.pyL);
        jPanel.add(this.pyTF);
        this.pzL = new JLabel("Position Z : ");
        this.pzTF = new JTextField();
        this.pzTF.addActionListener(this);
        jPanel.add(this.pzL);
        jPanel.add(this.pzTF);
        this.oriL = new JLabel("Orientation : ");
        this.oriTF = new JTextField();
        this.oriTF.addActionListener(this);
        jPanel.add(this.oriL);
        jPanel.add(this.oriTF);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.quitItem) {
            System.exit(0);
        } else if (actionEvent.getSource() == this.saveScriptItem) {
            this.fc.setApproveButtonText("Sauver");
            this.fc.setDialogTitle("Sauver...");
            this.saveCurrentEventData();
            this.events.trimToSize();
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                BufferedWriter bufferedWriter = null;
                try {
                    File file = this.fc.getSelectedFile();
                    bufferedWriter = new BufferedWriter(new FileWriter(file));
                    for (int i = 0; i < this.events.size(); ++i) {
                        bufferedWriter.write(this.events.get(i).toString() + "\n");
                    }
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    this.setStatus("Sauvegarde effectu\u00e9e.");
                }
                catch (IOException iOException) {
                    this.setStatus("Echec de la sauvegarde.");
                    iOException.printStackTrace();
                    return;
                }
            }
        } else if (actionEvent.getSource() == this.loadScriptItem) {
            this.fc.setApproveButtonText("Ouvrir");
            this.fc.setDialogTitle("Ouvrir...");
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                this.events.clear();
                BufferedReader bufferedReader = null;
                try {
                    File file = this.fc.getSelectedFile();
                    bufferedReader = new BufferedReader(new FileReader(file));
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        String[] stringArray = (string = string.substring(1, string.length() - 1)).split(", ");
                        if (stringArray.length != 28) {
                            throw new IOException();
                        }
                        SAIGenEventData sAIGenEventData = new SAIGenEventData();
                        sAIGenEventData.entry = Integer.parseInt(stringArray[0]);
                        sAIGenEventData.sourceType = Integer.parseInt(stringArray[1]);
                        sAIGenEventData.id = Integer.parseInt(stringArray[2]);
                        sAIGenEventData.link = Integer.parseInt(stringArray[3]);
                        sAIGenEventData.eventType = Integer.parseInt(stringArray[4]);
                        sAIGenEventData.eventPhaseMask = Integer.parseInt(stringArray[5]);
                        sAIGenEventData.eventChance = Integer.parseInt(stringArray[6]);
                        sAIGenEventData.eventFlags = Integer.parseInt(stringArray[7]);
                        sAIGenEventData.eventParam1 = Integer.parseInt(stringArray[8]);
                        sAIGenEventData.eventParam2 = Integer.parseInt(stringArray[9]);
                        sAIGenEventData.eventParam3 = Integer.parseInt(stringArray[10]);
                        sAIGenEventData.eventParam4 = Integer.parseInt(stringArray[11]);
                        sAIGenEventData.actionType = Integer.parseInt(stringArray[12]);
                        sAIGenEventData.actionParam1 = Integer.parseInt(stringArray[13]);
                        sAIGenEventData.actionParam2 = Integer.parseInt(stringArray[14]);
                        sAIGenEventData.actionParam3 = Integer.parseInt(stringArray[15]);
                        sAIGenEventData.actionParam4 = Integer.parseInt(stringArray[16]);
                        sAIGenEventData.actionParam5 = Integer.parseInt(stringArray[17]);
                        sAIGenEventData.actionParam6 = Integer.parseInt(stringArray[18]);
                        sAIGenEventData.targetType = Integer.parseInt(stringArray[19]);
                        sAIGenEventData.targetParam1 = Integer.parseInt(stringArray[20]);
                        sAIGenEventData.targetParam2 = Integer.parseInt(stringArray[21]);
                        sAIGenEventData.targetParam3 = Integer.parseInt(stringArray[22]);
                        sAIGenEventData.targetX = Float.parseFloat(stringArray[23]);
                        sAIGenEventData.targetY = Float.parseFloat(stringArray[24]);
                        sAIGenEventData.targetZ = Float.parseFloat(stringArray[25]);
                        sAIGenEventData.targetO = Float.parseFloat(stringArray[26]);
                        sAIGenEventData.comment = stringArray[27].substring(1, stringArray[27].length() - 1);
                        if (!this.events.contains(sAIGenEventData)) {
                            this.events.add(sAIGenEventData);
                        } else {
                            this.events.set(sAIGenEventData.id, sAIGenEventData);
                        }
                        this.initFields(this.events.get(this.events.size() - 1), true);
                        this.maxEvtId = this.events.size() - 1;
                    }
                    bufferedReader.close();
                    this.setStatus("Chargement effectu\u00e9.");
                }
                catch (IOException iOException) {
                    this.setStatus("Echec du chargement.");
                    this.events.clear();
                    this.initFields(null, false);
                    this.maxEvtId = 0;
                    ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setText(String.valueOf(this.maxEvtId));
                    return;
                }
            }
        } else if (actionEvent.getSource() == this.saveEventBtn) {
            this.saveCurrentEventData();
        } else if (actionEvent.getSource() == this.addEventBtn) {
            if (!this.saveCurrentEventData()) {
                return;
            }
            ++this.maxEvtId;
            this.initFields(null, false);
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setText(String.valueOf(this.maxEvtId));
        } else if (actionEvent.getSource() == this.removeEventBtn) {
            int n;
            if (this.maxEvtId > 0 && (n = JOptionPane.showConfirmDialog(null, "Voulez-vous vraiment supprimer cet event ?", "Confirmer la suppression", 0)) == 0) {
                --this.maxEvtId;
                int n2 = Integer.parseInt(((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().getText());
                ArrayList<SAIGenEventData> arrayList = new ArrayList<SAIGenEventData>();
                for (int i = 0; i < this.events.size(); ++i) {
                    if (i == n2) continue;
                    arrayList.add(this.events.get(i));
                    ((SAIGenEventData)arrayList.get((int)(arrayList.size() - 1))).id = arrayList.size() - 1;
                }
                this.events = arrayList;
                ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setText(String.valueOf(0));
                this.initFields(this.events.get(0), false);
                this.setStatus("Event supprim\u00e9.");
            }
        } else if (actionEvent.getSource() == this.typeCB) {
            this.updateLabels(0, this.typeCB.getSelectedIndex());
        } else if (actionEvent.getSource() == this.atypeCB) {
            this.updateLabels(1, this.atypeCB.getSelectedIndex());
        } else if (actionEvent.getSource() == this.ttypeCB) {
            this.updateLabels(2, this.ttypeCB.getSelectedIndex());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.spinner) {
            Integer n = (Integer)this.spinner.getValue();
            if (n > this.maxEvtId) {
                this.spinner.setValue(this.maxEvtId);
            }
            this.saveCurrentEventData();
            this.initFields(this.events.get((Integer)this.spinner.getValue()), true);
        }
    }

    public void initFields(SAIGenEventData sAIGenEventData, boolean bl) {
        if (sAIGenEventData == null) {
            this.linkTF.setText("0");
            this.chanceTF.setText("0");
            this.flagsTF.setText("0");
            this.ep1TF.setText("0");
            this.ep2TF.setText("0");
            this.ep3TF.setText("0");
            this.ep4TF.setText("0");
            this.commentTF.setText("Ins\u00e9rer commentaire");
            this.ap1TF.setText("0");
            this.ap2TF.setText("0");
            this.ap3TF.setText("0");
            this.ap4TF.setText("0");
            this.ap5TF.setText("0");
            this.ap6TF.setText("0");
            this.tp1TF.setText("0");
            this.tp2TF.setText("0");
            this.tp3TF.setText("0");
            this.pxTF.setText("0");
            this.pyTF.setText("0");
            this.pzTF.setText("0");
            this.oriTF.setText("0");
            this.typeCB.setSelectedIndex(0);
            this.atypeCB.setSelectedIndex(0);
            this.ttypeCB.setSelectedIndex(0);
        } else {
            if (bl) {
                this.entryField.setText(String.valueOf(sAIGenEventData.entry));
                ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setText(String.valueOf(sAIGenEventData.id));
            }
            this.linkTF.setText(String.valueOf(sAIGenEventData.link));
            this.chanceTF.setText(String.valueOf(sAIGenEventData.eventChance));
            this.flagsTF.setText(String.valueOf(sAIGenEventData.eventFlags));
            this.ep1TF.setText(String.valueOf(sAIGenEventData.eventParam1));
            this.ep2TF.setText(String.valueOf(sAIGenEventData.eventParam2));
            this.ep3TF.setText(String.valueOf(sAIGenEventData.eventParam3));
            this.ep4TF.setText(String.valueOf(sAIGenEventData.eventParam4));
            this.commentTF.setText(String.valueOf(sAIGenEventData.comment));
            this.ap1TF.setText(String.valueOf(sAIGenEventData.actionParam1));
            this.ap2TF.setText(String.valueOf(sAIGenEventData.actionParam2));
            this.ap3TF.setText(String.valueOf(sAIGenEventData.actionParam3));
            this.ap4TF.setText(String.valueOf(sAIGenEventData.actionParam4));
            this.ap5TF.setText(String.valueOf(sAIGenEventData.actionParam5));
            this.ap6TF.setText(String.valueOf(sAIGenEventData.actionParam6));
            this.tp1TF.setText(String.valueOf(sAIGenEventData.targetParam1));
            this.tp2TF.setText(String.valueOf(sAIGenEventData.targetParam2));
            this.tp3TF.setText(String.valueOf(sAIGenEventData.targetParam3));
            this.pxTF.setText(String.valueOf(sAIGenEventData.targetX));
            this.pyTF.setText(String.valueOf(sAIGenEventData.targetY));
            this.pzTF.setText(String.valueOf(sAIGenEventData.targetZ));
            this.oriTF.setText(String.valueOf(sAIGenEventData.targetO));
            this.typeCB.setSelectedIndex(sAIGenEventData.eventType);
            this.atypeCB.setSelectedIndex(sAIGenEventData.actionType);
            this.ttypeCB.setSelectedIndex(sAIGenEventData.targetType);
        }
    }

    public boolean saveCurrentEventData() {
        try {
            Integer.parseInt(this.entryField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setStatus("Sauvegarde \u00e9chou\u00e9e : ID du monstre vide !");
            return false;
        }
        SAIGenEventData sAIGenEventData = new SAIGenEventData();
        sAIGenEventData.entry = Integer.parseInt(this.entryField.getText());
        sAIGenEventData.sourceType = 0;
        sAIGenEventData.id = Integer.parseInt(((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().getText());
        sAIGenEventData.link = Integer.parseInt(this.linkTF.getText());
        sAIGenEventData.eventType = this.typeCB.getSelectedIndex();
        sAIGenEventData.eventPhaseMask = 0;
        sAIGenEventData.eventChance = Integer.parseInt(this.chanceTF.getText());
        sAIGenEventData.eventFlags = Integer.parseInt(this.flagsTF.getText());
        sAIGenEventData.eventParam1 = Integer.parseInt(this.ep1TF.getText());
        sAIGenEventData.eventParam2 = Integer.parseInt(this.ep2TF.getText());
        sAIGenEventData.eventParam3 = Integer.parseInt(this.ep3TF.getText());
        sAIGenEventData.eventParam4 = Integer.parseInt(this.ep4TF.getText());
        sAIGenEventData.actionType = this.atypeCB.getSelectedIndex();
        sAIGenEventData.actionParam1 = Integer.parseInt(this.ap1TF.getText());
        sAIGenEventData.actionParam2 = Integer.parseInt(this.ap2TF.getText());
        sAIGenEventData.actionParam3 = Integer.parseInt(this.ap3TF.getText());
        sAIGenEventData.actionParam4 = Integer.parseInt(this.ap4TF.getText());
        sAIGenEventData.actionParam5 = Integer.parseInt(this.ap5TF.getText());
        sAIGenEventData.actionParam6 = Integer.parseInt(this.ap6TF.getText());
        sAIGenEventData.targetType = this.ttypeCB.getSelectedIndex();
        sAIGenEventData.targetParam1 = Integer.parseInt(this.tp1TF.getText());
        sAIGenEventData.targetParam2 = Integer.parseInt(this.tp2TF.getText());
        sAIGenEventData.targetParam3 = Integer.parseInt(this.tp3TF.getText());
        sAIGenEventData.targetX = Float.parseFloat(this.pxTF.getText());
        sAIGenEventData.targetY = Float.parseFloat(this.pyTF.getText());
        sAIGenEventData.targetZ = Float.parseFloat(this.pzTF.getText());
        sAIGenEventData.targetO = Float.parseFloat(this.oriTF.getText());
        sAIGenEventData.comment = this.commentTF.getText();
        if (!this.events.contains(sAIGenEventData)) {
            this.events.add(sAIGenEventData);
        } else {
            this.events.set(sAIGenEventData.id, sAIGenEventData);
        }
        return true;
    }

    public void setStatus(String string) {
        this.statusText.setText(string);
    }

    private void updateLabels(int n, int n2) {
        switch (n) {
            case 0: {
                if (this.eventParam1Labels[n2] != null) {
                    this.ep1L.setText(this.eventParam1Labels[n2]);
                    this.ep1TF.setEditable(true);
                } else {
                    this.ep1L.setText("Non utilis\u00e9");
                    this.ep1TF.setEditable(false);
                }
                if (this.eventParam2Labels[n2] != null) {
                    this.ep2L.setText(this.eventParam2Labels[n2]);
                    this.ep2TF.setEditable(true);
                } else {
                    this.ep2L.setText("Non utilis\u00e9");
                    this.ep2TF.setEditable(false);
                }
                if (this.eventParam3Labels[n2] != null) {
                    this.ep3L.setText(this.eventParam3Labels[n2]);
                    this.ep3TF.setEditable(true);
                } else {
                    this.ep3L.setText("Non utilis\u00e9");
                    this.ep3TF.setEditable(false);
                }
                if (this.eventParam4Labels[n2] != null) {
                    this.ep4L.setText(this.eventParam4Labels[n2]);
                    this.ep4TF.setEditable(true);
                    break;
                }
                this.ep4L.setText("Non utilis\u00e9");
                this.ep4TF.setEditable(false);
                break;
            }
            case 1: {
                if (this.actionParam1Labels[n2] != null) {
                    this.ap1L.setText(this.actionParam1Labels[n2]);
                    this.ap1TF.setEditable(true);
                } else {
                    this.ap1L.setText("Non utilis\u00e9");
                    this.ap1TF.setEditable(false);
                }
                if (this.actionParam2Labels[n2] != null) {
                    this.ap2L.setText(this.actionParam2Labels[n2]);
                    this.ap2TF.setEditable(true);
                } else {
                    this.ap2L.setText("Non utilis\u00e9");
                    this.ap2TF.setEditable(false);
                }
                if (this.actionParam3Labels[n2] != null) {
                    this.ap3L.setText(this.actionParam3Labels[n2]);
                    this.ap3TF.setEditable(true);
                } else {
                    this.ap3L.setText("Non utilis\u00e9");
                    this.ap3TF.setEditable(false);
                }
                if (this.actionParam4Labels[n2] != null) {
                    this.ap4L.setText(this.actionParam4Labels[n2]);
                    this.ap4TF.setEditable(true);
                } else {
                    this.ap4L.setText("Non utilis\u00e9");
                    this.ap4TF.setEditable(false);
                }
                if (this.actionParam5Labels[n2] != null) {
                    this.ap5L.setText(this.actionParam5Labels[n2]);
                    this.ap5TF.setEditable(true);
                } else {
                    this.ap5L.setText("Non utilis\u00e9");
                    this.ap5TF.setEditable(false);
                }
                if (this.actionParam6Labels[n2] != null) {
                    this.ap6L.setText(this.actionParam6Labels[n2]);
                    this.ap6TF.setEditable(true);
                    break;
                }
                this.ap6L.setText("Non utilis\u00e9");
                this.ap6TF.setEditable(false);
                break;
            }
            case 2: {
                if (this.targetParam1Labels[n2] != null) {
                    this.tp1L.setText(this.targetParam1Labels[n2]);
                    this.tp1TF.setEditable(true);
                } else {
                    this.tp1L.setText("Non utilis\u00e9");
                    this.tp1TF.setEditable(false);
                }
                if (this.targetParam2Labels[n2] != null) {
                    this.tp2L.setText(this.targetParam2Labels[n2]);
                    this.tp2TF.setEditable(true);
                } else {
                    this.tp2L.setText("Non utilis\u00e9");
                    this.tp2TF.setEditable(false);
                }
                if (this.targetParam3Labels[n2] != null) {
                    this.tp3L.setText(this.targetParam3Labels[n2]);
                    this.tp3TF.setEditable(true);
                } else {
                    this.tp3L.setText("Non utilis\u00e9");
                    this.tp3TF.setEditable(false);
                }
                if (this.targetXLabels[n2] != null) {
                    this.pxL.setText(this.targetXLabels[n2]);
                    this.pxTF.setEditable(true);
                } else {
                    this.pxL.setText("Non utilis\u00e9");
                    this.pxTF.setEditable(false);
                }
                if (this.targetYLabels[n2] != null) {
                    this.pyL.setText(this.targetYLabels[n2]);
                    this.pyTF.setEditable(true);
                } else {
                    this.pyL.setText("Non utilis\u00e9");
                    this.pyTF.setEditable(false);
                }
                if (this.targetZLabels[n2] != null) {
                    this.pzL.setText(this.targetZLabels[n2]);
                    this.pzTF.setEditable(true);
                } else {
                    this.pzL.setText("Non utilis\u00e9");
                    this.pzTF.setEditable(false);
                }
                if (this.targetOLabels[n2] != null) {
                    this.oriL.setText(this.targetOLabels[n2]);
                    this.oriTF.setEditable(true);
                    break;
                }
                this.oriL.setText("Non utilis\u00e9");
                this.oriTF.setEditable(false);
                break;
            }
            default: {
                System.err.println("updateLabels: Unknown type " + n);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setStatus("");
    }
}

